#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_VistALinkConfig : BaseTest 
	{
		private string VistaAppServerHandle = "Primary";

		[SetUp]
		protected void SetUp()
		{
			//TODO: Remove unnecessary blank constructor in DAL.VistaLinkConfig class
			this.BaseSetUp();
		    DataCreator.ResetVistaLinkControlTable();
		}

		[TearDown]
		protected void TearDown()
		{
		    DataCreator.ResetVistaLinkControlTable();
		}

		[Test]
		public void Load_Pass_1()
		{
			Assert.IsNotNull( VistALinkConfig.Load(VistaAppServerHandle ) );
		}

		[Test]
		public void Load_Pass_2()
		{
		    UnitTestUtil.RunSQL("DELETE FROM " + TABLES.VistaLinkControl.TableName); 
			Assert.IsNull( VistALinkConfig.Load( VistaAppServerHandle ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Load_Fail() 
		{
			//Cannot test InsufficientNumberOfDataRowsFoundWhileExpectingSingleRow condition in VistALinkConfig.Load()
			//The stored procedure selects data based on the primary key, so > 1 row can never be returned.
			//TODO: Remove unreachable code catch for rowcount > 1 in DAL
			VistALinkConfig.Load( null );
		}

		private DataRow GetVistALinkConfigDataRowFromDb()
		{
			return UnitTestUtil.RunSQLGetDataRow( String.Format( "select top 1 * from {0}", TABLES.VistaLinkControl.TableName ) );
		}

		private DataRow GetUpdatePreparedTestDataRow()
		{
			DataRow _dr = VistALinkConfig.GetVistaLinkControlEmptyDataTable().NewRow();

			_dr[ TABLES.VistaLinkControl.ServerAppHandle ] = VistALinkUnitTestHarness.TestData.VistAServerAppHandle;
			_dr[ TABLES.VistaLinkControl.ServerAlias ] = VistALinkUnitTestHarness.TestData.VistAServerAlias;
			_dr[ TABLES.VistaLinkControl.VistaIpAddress ] = VistALinkUnitTestHarness.TestData.VistaIpAddressString;
			_dr[ TABLES.VistaLinkControl.VistaPortNumber ] = VistALinkUnitTestHarness.TestData.VistaPortNumber;
		    _dr[ TABLES.VistaLinkControl.VbecsServiceIpAddress] = "10.3.21.77";
		    _dr[ TABLES.VistaLinkControl.VbecsServicePortNumber] = "42074";
			_dr[ TABLES.VistaLinkControl.LastUpdateFunctionId ] = (int)Common.UpdateFunction.MUC01_EditVistALinkConnectionParameters;

			return _dr;
		}

		private void VerifyTestDataPersistence()
		{
			DataRow _drUnderTest = GetVistALinkConfigDataRowFromDb();

			Assert.AreEqual( VistALinkUnitTestHarness.TestData.VistaIpAddressString, Convert.ToString( _drUnderTest[ TABLES.VistaLinkControl.VistaIpAddress ] ).Trim() );
			Assert.AreEqual( VistALinkUnitTestHarness.TestData.VistaPortNumber, Convert.ToInt32( _drUnderTest[ TABLES.VistaLinkControl.VistaPortNumber ] ) );
		}

		private void SavePreparedTestDataRowAndVerifyPersistence( object rowversion )
		{
			DataRow _drForUpdate = GetUpdatePreparedTestDataRow();
			_drForUpdate[ TABLES.VistaLinkControl.RowVersion ] = rowversion;

			VistALinkConfig.Save( _drForUpdate );
			VerifyTestDataPersistence();
		}

		[Test]
		public void Save_Pass_1()
		{
			DataRow _drCurrent = GetVistALinkConfigDataRowFromDb();
			SavePreparedTestDataRowAndVerifyPersistence( (byte[])_drCurrent[ TABLES.VistaLinkControl.RowVersion ] );			
		}
		
		[Test]
		public void Save_Pass_2()
		{
            UnitTestUtil.RunSQL("DELETE FROM " + TABLES.VistaLinkControl.TableName); 
			SavePreparedTestDataRowAndVerifyPersistence( System.DBNull.Value );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Save_Fail_1()
		{
			VistALinkConfig.Save( null );
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Save_Fail_2()
		{
			VistALinkConfig.Save( new DataTable().NewRow() );
		}

		[Test]
		public void GetVistaLinkControlEmptyDataTable_Pass()
		{
			Assert.IsNotNull( VistALinkConfig.GetVistaLinkControlEmptyDataTable() );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetVistaLinkControlEmptyDataTable_Fail() {}
	}
}

#endif
